<?php

namespace app\controllers;

use Yii;
use yii\web\Controller;
use yii\filters\AccessControl;

class TwofaController extends Controller
{
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::class,
                'rules' => [
                    [
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
        ];
    }

    public function actionIndex()
    {
        $user = Yii::$app->user->identity;
        return $this->render('index', ['user' => $user]);
    }

    public function actionEnable()
    {
        $user = Yii::$app->user->identity;

        // Генерируем секрет
        $secret = $this->generateBase32Secret(16); // 16 символов Base32

        // Сохраняем в сессию
        Yii::$app->session->set('2fa_temp_secret', $secret);

        // Получаем название сайта
        $issuer = Yii::$app->params['siteName'] ?? Yii::$app->id ?? 'MySite';

        // Формируем URL для QR-кода вручную
        $otpAuthUrl = 'otpauth://totp/' . urlencode($issuer) . ':' . urlencode($user->username)
            . '?secret=' . $secret
            . '&issuer=' . urlencode($issuer);

        // URL картинки QR-кода через Google Charts
        $qrUrl = 'https://chart.googleapis.com/chart?chs=250x250&cht=qr&chl=' . urlencode($otpAuthUrl);

        return $this->render('enable', [
            'user' => $user,
            'secret' => $secret,
            'qrUrl' => $qrUrl,
        ]);
    }

    /**
     * Генерация Base32 ключа (правильный формат для Google Authenticator)
     */
    private function generateBase32Secret($length = 16)
    {
        $alphabet = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ234567';
        $secret = '';
        for ($i = 0; $i < $length; $i++) {
            $secret .= $alphabet[random_int(0, strlen($alphabet) - 1)];
        }
        return $secret;
    }

    /**
     * Подтверждение кода и включение 2FA
     */
    public function actionVerify()
    {
        $user = Yii::$app->user->identity;

        $secret = Yii::$app->session->get('2fa_temp_secret');

        if (!$secret) {
            Yii::$app->session->setFlash('error', 'Сессия истекла. Начните заново.');
            return $this->redirect(['enable']);
        }

        if (Yii::$app->request->isPost) {
            $code = Yii::$app->request->post('code');

            if ($user->verifyCode($code, $secret)) {


                $user->enableOtp($secret);

                Yii::$app->session->remove('2fa_temp_secret');

                Yii::$app->session->setFlash('success', 'Двухфакторная авторизация успешно включена!');
                return $this->redirect(['index']);

            } else {
                Yii::$app->session->setFlash('error', 'Неверный код. Попробуйте ещё раз.');
            }
        }

        return $this->render('verify', [
            'user' => $user,
        ]);
    }

    public function actionDisable()
    {
        $user = Yii::$app->user->identity;

        if (Yii::$app->request->isPost) {
            $code = Yii::$app->request->post('code');

            if ($user->verifyCode($code)) {
                $user->disableOtp();
                Yii::$app->session->setFlash('success', '2FA отключена');
            } else {
                Yii::$app->session->setFlash('error', 'Неверный код');
            }
        }

        return $this->redirect(['index']);
    }
}