<?php

use yii\db\Migration;

/**
 * Handles the creation of table `user`.
 */
class m260216_055706_create_user_table extends Migration
{
    public function safeUp()
    {
        $this->createTable('user', [
            'id' => $this->primaryKey(),
            'username' => $this->string()->notNull()->unique(),
            'password' => $this->string()->notNull(),
            'email' => $this->string()->notNull()->unique(),
            'created_at' => $this->dateTime()->notNull()->defaultExpression('CURRENT_TIMESTAMP'),
            'updated_at' => $this->dateTime()->notNull()->defaultExpression('CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP'),
            'otp_secret' => $this->string(),
            'otp_enabled' => $this->boolean()->notNull()->defaultValue(false),
        ]);
    }

    public function safeDown()
    {
        $this->dropTable('user');
    }
}