<?php
use yii\helpers\Html;
use yii\helpers\Url;

$this->title = 'Двухфакторная авторизация';
?>

<div class="site-twofa-login">
    <div class="row">
        <div class="col-md-6 col-md-offset-3">
            <div class="panel panel-primary">
                <div class="panel-heading">
                    <h3 class="panel-title"><?= Html::encode($this->title) ?></h3>
                </div>
                <div class="panel-body">

                    <?php if (Yii::$app->session->hasFlash('error')): ?>
                        <div class="alert alert-danger">
                            <?= Yii::$app->session->getFlash('error') ?>
                        </div>
                    <?php endif; ?>

                    <div class="alert alert-info">
                        <strong>Пользователь:</strong> <?= Html::encode($user->username) ?>
                    </div>

                    <p>Введите код из приложения Google Authenticator:</p>

                    <form action="<?= Url::to(['twofa-login']) ?>" method="post">
                        <input type="hidden" name="_csrf" value="<?= Yii::$app->request->csrfToken ?>">

                        <div class="form-group">
                            <input type="text" class="form-control input-lg text-center"
                                   name="code" placeholder="______" maxlength="6" pattern="[0-9]{6}"
                                   style="font-size: 30px; letter-spacing: 10px;" autofocus required>
                        </div>

                        <?= Html::submitButton('Подтвердить', ['class' => 'btn btn-success btn-block']) ?>
                    </form>

                    <hr>

                    <?= Html::a('Вернуться к входу', ['login'], ['class' => 'btn btn-link']) ?>
                </div>
            </div>
        </div>
    </div>
</div>